# PCI Device Discovery Issue - One Page Summary
**ZOTAC ZBOX-CI320NANO with Coreboot MMIO Patch**

---

## Problem Statement
PCIe WiFi card (Intel 3160 at 01:00.0) fails when MMIO patch is applied to Coreboot, but identical Bay Trail hardware (Swanky Chromebook) works correctly with the same patch.

---

## Root Cause: PCIe Bus Discovery Method

### ZBOX (Broken)
```
[0.300966] PCI: Discovered peer bus 01
[0.301081] pci_bus 0000:01: root bus resource [mem 0x00000000-0xfffffffff]
```
**Linux treats bus 01 as independent "peer bus" → unlimited address range → conflict**

### Swanky (Working)
```
[0.237285] pci 0000:00:1c.0: PCI bridge to [bus 01]
[0.345008] pci_bus 0000:01: resource 1 [mem 0xfd900000-0xfd9fffff]
```
**Linux discovers bus 01 through bridge → bounded window → no conflict**

---

## Why This Matters

**With proper bridge discovery (Swanky):**
- Bus 01 inherits bounded window: `[mem 0xfd900000-0xfd9fffff]`
- WiFi at `0xFD900000` is within its own bus's window
- No conflict with bus 00's MMIO window `0xF0000000-0xFDFFFFFF`
- ✅ **WiFi works**

**With peer bus discovery (ZBOX):**
- Bus 01 gets unlimited range: `[mem 0x00000000-0xfffffffff]`
- Overlaps with bus 00's MMIO window `0xF0000000-0xFDFFFFFF`
- WiFi at `0xFDB00000` claimed by BOTH bus 00 and bus 01
- Linux: "Conflict! Move WiFi above 4GB" → `0x100000000`
- Device becomes inaccessible at new address (reads return `0xFFFFFFFF`)
- ❌ **WiFi broken** (probe fails with error -5)

---

## Technical Details

**What Coreboot Does (Both Systems):**
- ✅ Correctly allocates bridge window at `0xFDB00000-0xFDBFFFFF`
- ✅ Assigns WiFi device to `0xFDB00000` within bridge window
- ✅ Sets bridge memory window register (offset 0x20)

**What ACPI Tells Linux (Different!):**
- **Swanky ACPI**: Bridge 00:1c.0 properly declared with subordinate bus 01
- **ZBOX ACPI**: Bus 01 declared as separate PCI root (peer bus)

---

## Why "Peer Bus" Discovery Happens

ZBOX's ACPI tables likely contain one or more of:

1. **Separate PCI root device** for bus 01 in DSDT
   ```asl
   Device (PCI1) {                    // Should NOT exist
       Name (_HID, EISAID("PNP0A08"))
       Name (_BBN, 0x01)              // Base bus 01
   }
   ```

2. **Missing/incorrect bridge device** definition for 00:1c.2

3. **MCFG table** listing bus 01 as separate segment

4. **Missing subordinate bus number** in bridge configuration

---

## Why MMIO Patch Triggers the Issue

**WITHOUT MMIO Patch:**
- ACPI doesn't define `0xF0000000-0xFDFFFFFF` window
- All devices fail to claim BARs (no compatible window)
- Linux reassigns everything to `0x80000000` range
- Peer bus bug is **masked** by full reassignment
- ✅ Works by accident

**WITH MMIO Patch:**
- ACPI defines `0xF0000000-0xFDFFFFFF` window for bus 00
- Bus 00 devices claim their BARs successfully
- Peer bus bug is **exposed**: bus 01's unlimited range conflicts
- WiFi relocated above 4GB → broken
- ❌ Fails

---

## The Fix

**Primary Solution**: Correct ZBOX's ACPI tables
1. Remove any separate PCI root device for bus 01
2. Ensure bridge 00:1c.2 is properly declared with subordinate bus
3. Define bridge window in _CRS method

**Expected result after fix:**
```
pci 0000:00:1c.2: PCI bridge to [bus 01]
pci 0000:00:1c.2:   bridge window [mem 0xfdb00000-0xfdbfffff]
pci_bus 0000:01: resource 1 [mem 0xfdb00000-0xfdbfffff]
```

**Alternative Workaround**: Allocate PCIe bridge in 0x80-0xDF range
- Avoids the 0xF0-0xFD "danger zone" entirely
- Works even with peer bus bug (no overlap to conflict)

---

## Verification Steps

1. Extract ACPI tables: `sudo cat /sys/firmware/acpi/tables/DSDT > dsdt.bin`
2. Decompile: `iasl -d dsdt.bin`
3. Search for: `grep -c "PNP0A08" dsdt.dsl` (should be 1, not 2+)
4. Look for bridge definitions: `grep "Device.*1C\|Device (RP" dsdt.dsl`

---

## Key Takeaway

**The MMIO patch itself is not the problem.** It exposes a pre-existing ACPI bug where ZBOX declares bus 01 as a peer bus instead of subordinate to its parent PCIe bridge. Swanky's ACPI is correct, so it works. Fix ZBOX's ACPI to match Swanky's bridge hierarchy.

---

**Issue**: ACPI configuration bug  
**Impact**: WiFi non-functional with MMIO patch  
**Fix Location**: Coreboot ACPI table generation (DSDT)  
**Status**: Workaround available (no MMIO patch), permanent fix requires ACPI update

