/*
 * Intel ACPI Component Architecture
 * AML/ASL+ Disassembler version 20230628 (64-bit version)
 * Copyright (c) 2000 - 2023 Intel Corporation
 * 
 * Disassembling to symbolic ASL+ operators
 *
 * Disassembly of dsdt.bin, Sat Oct 18 07:15:26 2025
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00002A76 (10870)
 *     Revision         0x02
 *     Checksum         0x3D
 *     OEM ID           "COREv4"
 *     OEM Table ID     "COREBOOT"
 *     OEM Revision     0x20110725 (537986853)
 *     Compiler ID      "INTL"
 *     Compiler Version 0x20250404 (539296772)
 */
DefinitionBlock ("", "DSDT", 2, "COREv4", "COREBOOT", 0x20110725)
{
    External (_SB_.CNOT, MethodObj)    // 1 Arguments
    External (DNVS, OpRegionObj)
    External (GNVS, OpRegionObj)
    External (OSFG, IntObj)
    External (TOLM, IntObj)

    Scope (\)
    {
        OperationRegion (GNVS, SystemMemory, 0x7AFFE660, 0x3C)
        OperationRegion (DNVS, SystemMemory, 0x7AFFE6A0, 0xA6)
    }

    Name (OSYS, Zero)
    Name (PICM, Zero)
    Name (PWRS, One)
    Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
    {
        PICM = Arg0
    }

    Scope (_SB)
    {
        Name (PCBA, 0xE0000000)
        Name (PCLN, 0x10000000)
        OperationRegion (PCFG, SystemMemory, PCBA, PCLN)
        Device (PERC)
        {
            Name (_HID, EisaId ("PNP0C02") /* PNP Motherboard Resources */)  // _HID: Hardware ID
            Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
            {
                Name (RBUF, ResourceTemplate ()
                {
                    QWordMemory (ResourceConsumer, PosDecode, MinFixed, MaxFixed, NonCacheable, ReadWrite,
                        0x0000000000000000, // Granularity
                        0x0000000000000000, // Range Minimum
                        0x0000000000000001, // Range Maximum
                        0x0000000000000000, // Translation Offset
                        0x0000000000000002, // Length
                        ,, _Y00, AddressRangeMemory, TypeStatic)
                })
                CreateQWordField (RBUF, \_SB.PERC._CRS._Y00._MIN, MIN1)  // _MIN: Minimum Base Address
                CreateQWordField (RBUF, \_SB.PERC._CRS._Y00._MAX, MAX1)  // _MAX: Maximum Base Address
                CreateQWordField (RBUF, \_SB.PERC._CRS._Y00._LEN, LEN1)  // _LEN: Length
                MIN1 = 0xE0000000
                MAX1 = ((MIN1 + 0x10000000) - One)
                LEN1 = 0x10000000
                Return (RBUF) /* \_SB_.PERC._CRS.RBUF */
            }
        }
    }

    Field (DNVS, ByteAcc, NoLock, Preserve)
    {
        S0EN,   8, 
        S1EN,   8, 
        S2EN,   8, 
        S3EN,   8, 
        S4EN,   8, 
        S5EN,   8, 
        S6EN,   8, 
        S7EN,   8, 
        S8EN,   8, 
        S9EN,   8, 
        SAEN,   8, 
        SBEN,   8, 
        SCEN,   8, 
        SDEN,   8, 
        C0EN,   8, 
        C1EN,   8, 
        C2EN,   8, 
        LPEN,   8, 
        S0B0,   32, 
        S1B0,   32, 
        S2B0,   32, 
        S3B0,   32, 
        S4B0,   32, 
        S5B0,   32, 
        S6B0,   32, 
        S7B0,   32, 
        S8B0,   32, 
        S9B0,   32, 
        SAB0,   32, 
        SBB0,   32, 
        SCB0,   32, 
        SDB0,   32, 
        C0B0,   32, 
        C1B0,   32, 
        C2B0,   32, 
        LPB0,   32, 
        S0B1,   32, 
        S1B1,   32, 
        S2B1,   32, 
        S3B1,   32, 
        S4B1,   32, 
        S5B1,   32, 
        S6B1,   32, 
        S7B1,   32, 
        S8B1,   32, 
        S9B1,   32, 
        SAB1,   32, 
        SBB1,   32, 
        SCB1,   32, 
        SDB1,   32, 
        C0B1,   32, 
        C1B1,   32, 
        C2B1,   32, 
        LPB1,   32, 
        LPFW,   32
    }

    OperationRegion (APMP, SystemIO, 0xB2, 0x02)
    Field (APMP, ByteAcc, NoLock, Preserve)
    {
        APMC,   8, 
        APMS,   8
    }

    OperationRegion (POST, SystemIO, 0x80, One)
    Field (POST, ByteAcc, Lock, Preserve)
    {
        DBG0,   8
    }

    Method (GOS, 0, NotSerialized)
    {
        OSYS = 0x07D0
        If (CondRefOf (_OSI))
        {
            If (_OSI ("Windows 2001"))
            {
                OSYS = 0x07D1
            }

            If (_OSI ("Windows 2001 SP1"))
            {
                OSYS = 0x07D1
            }

            If (_OSI ("Windows 2001 SP2"))
            {
                OSYS = 0x07D2
            }

            If (_OSI ("Windows 2006"))
            {
                OSYS = 0x07D6
            }
        }
    }

    Method (HPTS, 1, NotSerialized)
    {
        If (!Arg0)
        {
            Return (Zero)
        }

        If ((OSYS < 0x07D1))
        {
            Return (0x0B)
        }

        Return (0x0F)
    }

    Method (_PTS, 1, NotSerialized)  // _PTS: Prepare To Sleep
    {
    }

    Method (_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        Return (Package (0x02)
        {
            Zero, 
            Zero
        })
    }

    Method (_SWS, 0, NotSerialized)  // _SWS: System Wake Source
    {
        Return (PM1I) /* \PM1I */
    }

    Field (GNVS, ByteAcc, NoLock, Preserve)
    {
        Offset (0x02), 
        SMIF,   8, 
        Offset (0x04), 
        Offset (0x05), 
        SCIF,   8, 
        Offset (0x07), 
        Offset (0x08), 
        Offset (0x09), 
        Offset (0x0A), 
        Offset (0x0B), 
        P80D,   32, 
        LIDS,   8, 
        Offset (0x11), 
        Offset (0x12), 
        TPMP,   8, 
        TLVL,   8, 
        PPCM,   8, 
        PM1I,   32, 
        GPEI,   32, 
        Offset (0x20), 
        S5U0,   8, 
        S5U1,   8, 
        S3U0,   8, 
        S3U1,   8, 
        TACT,   8, 
        TPSV,   8, 
        TCRT,   8, 
        DPTE,   8, 
        Offset (0x30), 
        Offset (0x34), 
        Offset (0x38), 
        Offset (0x3C)
    }

    Method (PNOT, 0, NotSerialized)
    {
        \_SB.CNOT (0x81)
    }

    Method (PPCN, 0, NotSerialized)
    {
        \_SB.CNOT (0x80)
    }

    Method (TNOT, 0, NotSerialized)
    {
        \_SB.CNOT (0x82)
    }

    Device (_SB.PCI0)
    {
        Scope (\)
        {
            OperationRegion (ILBS, SystemMemory, 0xFED08000, 0x0400)
            Field (ILBS, AnyAcc, NoLock, Preserve)
            {
                Offset (0x08), 
                PRTA,   8, 
                PRTB,   8, 
                PRTC,   8, 
                PRTD,   8, 
                PRTE,   8, 
                PRTF,   8, 
                PRTG,   8, 
                PRTH,   8
            }
        }

        Name (_HID, EisaId ("PNP0A08") /* PCI Express Bus */)  // _HID: Hardware ID
        Name (_CID, EisaId ("PNP0A03") /* PCI Bus */)  // _CID: Compatible ID
        Name (_BBN, Zero)  // _BBN: BIOS Bus Number
        Name (MCRS, ResourceTemplate ()
        {
            WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                0x0000,             // Granularity
                0x0000,             // Range Minimum
                0x00FF,             // Range Maximum
                0x0000,             // Translation Offset
                0x0100,             // Length
                ,, )
            DWordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                0x00000000,         // Granularity
                0x00000000,         // Range Minimum
                0x00000CF7,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00000CF8,         // Length
                ,, , TypeStatic, DenseTranslation)
            IO (Decode16,
                0x0CF8,             // Range Minimum
                0x0CF8,             // Range Maximum
                0x01,               // Alignment
                0x08,               // Length
                )
            DWordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                0x00000000,         // Granularity
                0x00000D00,         // Range Minimum
                0x0000FFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x0000F300,         // Length
                ,, , TypeStatic, DenseTranslation)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000A0000,         // Range Minimum
                0x000BFFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00020000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000C0000,         // Range Minimum
                0x000C3FFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000C4000,         // Range Minimum
                0x000C7FFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000C8000,         // Range Minimum
                0x000CBFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000CC000,         // Range Minimum
                0x000CFFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000D0000,         // Range Minimum
                0x000D3FFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000D4000,         // Range Minimum
                0x000D7FFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000D8000,         // Range Minimum
                0x000DBFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000DC000,         // Range Minimum
                0x000DFFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000E0000,         // Range Minimum
                0x000E3FFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000E4000,         // Range Minimum
                0x000E7FFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000E8000,         // Range Minimum
                0x000EBFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000EC000,         // Range Minimum
                0x000EFFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00004000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x000F0000,         // Range Minimum
                0x000FFFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00010000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x00000000,         // Range Minimum
                0x00000000,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00000000,         // Length
                ,, _Y01, AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0x00000000,         // Range Minimum
                0x00000000,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00000000,         // Length
                ,, _Y02, AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0xF0000000,         // Range Minimum
                0xFDFFFFFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x0E000000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
            DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                0x00000000,         // Granularity
                0xFED40000,         // Range Minimum
                0xFED44FFF,         // Range Maximum
                0x00000000,         // Translation Offset
                0x00005000,         // Length
                ,, , AddressRangeMemory, TypeStatic)
        })
        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
        {
            CreateDWordField (MCRS, \_SB.PCI0._Y01._MIN, LMIN)  // _MIN: Minimum Base Address
            CreateDWordField (MCRS, \_SB.PCI0._Y01._MAX, LMAX)  // _MAX: Maximum Base Address
            CreateDWordField (MCRS, \_SB.PCI0._Y01._LEN, LLEN)  // _LEN: Length
            If (((LPFW != Zero) && (LPEN == One)))
            {
                LMIN = LPFW /* \LPFW */
                LLEN = 0x00100000
                LMAX = ((LMIN + LLEN) - One)
            }
            Else
            {
                LMIN = Zero
                LMAX = Zero
                LLEN = Zero
            }

            CreateDWordField (MCRS, \_SB.PCI0._Y02._MIN, PMIN)  // _MIN: Minimum Base Address
            CreateDWordField (MCRS, \_SB.PCI0._Y02._MAX, PMAX)  // _MAX: Maximum Base Address
            CreateDWordField (MCRS, \_SB.PCI0._Y02._LEN, PLEN)  // _LEN: Length
            PMIN = TOLM /* External reference */
            PMAX = 0xDFFFFFFF
            PLEN = ((PMAX - PMIN) + One)
            Return (MCRS) /* \_SB_.PCI0.MCRS */
        }

        Device (PDRC)
        {
            Name (_HID, EisaId ("PNP0C02") /* PNP Motherboard Resources */)  // _HID: Hardware ID
            Name (_UID, One)  // _UID: Unique ID
            Name (PDRS, ResourceTemplate ()
            {
                Memory32Fixed (ReadWrite,
                    0xFEB00000,         // Address Base
                    0x00100000,         // Address Length
                    )
                Memory32Fixed (ReadWrite,
                    0xFED03000,         // Address Base
                    0x00000400,         // Address Length
                    )
                Memory32Fixed (ReadWrite,
                    0xFED08000,         // Address Base
                    0x00000400,         // Address Length
                    )
                Memory32Fixed (ReadWrite,
                    0xFED01000,         // Address Base
                    0x00000400,         // Address Length
                    )
                Memory32Fixed (ReadWrite,
                    0xFEF00000,         // Address Base
                    0x00100000,         // Address Length
                    )
                Memory32Fixed (ReadWrite,
                    0xFED05000,         // Address Base
                    0x00000800,         // Address Length
                    )
                Memory32Fixed (ReadWrite,
                    0xFED1C000,         // Address Base
                    0x00000400,         // Address Length
                    )
            })
            Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
            {
                Return (PDRS) /* \_SB_.PCI0.PDRC.PDRS */
            }
        }

        Method (_OSC, 4, NotSerialized)  // _OSC: Operating System Capabilities
        {
            If ((Arg0 == ToUUID ("33db4d5b-1ff7-401c-9657-7441c03dd766") /* PCI Host Bridge Device */))
            {
                Return (Arg3)
            }
            Else
            {
                CreateDWordField (Arg3, Zero, CDW1)
                CDW1 |= 0x04
                Return (Arg3)
            }
        }

        Device (IOSF)
        {
            Name (_HID, "INT33BD" /* Intel Baytrail Mailbox Device */)  // _HID: Hardware ID
            Name (_CID, "INT33BD" /* Intel Baytrail Mailbox Device */)  // _CID: Compatible ID
            Name (_UID, One)  // _UID: Unique ID
            Name (RBUF, ResourceTemplate ()
            {
                Memory32Fixed (ReadWrite,
                    0x00000000,         // Address Base
                    0x0000000C,         // Address Length
                    _Y03)
            })
            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateDWordField (RBUF, \_SB.PCI0.IOSF._Y03._BAS, RBAS)  // _BAS: Base Address
                RBAS = 0xE00000D0
                Return (RBUF) /* \_SB_.PCI0.IOSF.RBUF */
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (Zero)
            }
        }

        Device (LPCB)
        {
            Name (_ADR, 0x001F0000)  // _ADR: Address
            Device (LNKA)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, One)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTA = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,10,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLA, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLA, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTA & 0x0F))
                    Return (RTLA) /* \_SB_.PCI0.LPCB.LNKA._CRS.RTLA */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTA = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTA & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (LNKB)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTB = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,11,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLB, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLB, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTB & 0x0F))
                    Return (RTLB) /* \_SB_.PCI0.LPCB.LNKB._CRS.RTLB */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTB = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTB & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (LNKC)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTC = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,10,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLC, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTC & 0x0F))
                    Return (RTLC) /* \_SB_.PCI0.LPCB.LNKC._CRS.RTLC */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTC = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTC & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (LNKD)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, 0x04)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTD = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,11,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLD, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLD, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTD & 0x0F))
                    Return (RTLD) /* \_SB_.PCI0.LPCB.LNKD._CRS.RTLD */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTD = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTD & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (LNKE)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, 0x05)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTE = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,10,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLE, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLE, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTE & 0x0F))
                    Return (RTLE) /* \_SB_.PCI0.LPCB.LNKE._CRS.RTLE */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTE = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTE & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (LNKF)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, 0x06)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTF = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,11,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLF, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLF, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTF & 0x0F))
                    Return (RTLF) /* \_SB_.PCI0.LPCB.LNKF._CRS.RTLF */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTF = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTF & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (LNKG)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, 0x07)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTG = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,10,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLG, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLG, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTG & 0x0F))
                    Return (RTLG) /* \_SB_.PCI0.LPCB.LNKG._CRS.RTLG */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTG = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTG & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (LNKH)
            {
                Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                Name (_UID, 0x08)  // _UID: Unique ID
                Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                {
                    PRTH = 0x80
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    IRQ (Level, ActiveLow, Shared, )
                        {3,4,5,6,7,11,12,14,15}
                })
                Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                {
                    Name (RTLH, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {}
                    })
                    CreateWordField (RTLH, One, IRQ0)
                    IRQ0 = Zero
                    IRQ0 = (One << (PRTH & 0x0F))
                    Return (RTLH) /* \_SB_.PCI0.LPCB.LNKH._CRS.RTLH */
                }

                Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, One, IRQ0)
                    FindSetRightBit (IRQ0, Local0)
                    Local0--
                    PRTH = Local0
                }

                Method (_STA, 0, Serialized)  // _STA: Status
                {
                    If ((PRTH & 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }
            }

            Device (DMAC)
            {
                Name (_HID, EisaId ("PNP0200") /* PC-class DMA Controller */)  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x20,               // Length
                        )
                    IO (Decode16,
                        0x0081,             // Range Minimum
                        0x0081,             // Range Maximum
                        0x01,               // Alignment
                        0x11,               // Length
                        )
                    IO (Decode16,
                        0x0093,             // Range Minimum
                        0x0093,             // Range Maximum
                        0x01,               // Alignment
                        0x0D,               // Length
                        )
                    IO (Decode16,
                        0x00C0,             // Range Minimum
                        0x00C0,             // Range Maximum
                        0x01,               // Alignment
                        0x20,               // Length
                        )
                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                        {4}
                })
            }

            Device (FWH)
            {
                Name (_HID, EisaId ("INT0800") /* Intel 82802 Firmware Hub Device */)  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    Memory32Fixed (ReadOnly,
                        0xFF000000,         // Address Base
                        0x01000000,         // Address Length
                        )
                })
            }

            Device (HPET)
            {
                Name (_HID, EisaId ("PNP0103") /* HPET System Timer */)  // _HID: Hardware ID
                Name (_CID, EisaId ("PNP0C01") /* System Board */)  // _CID: Compatible ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    Memory32Fixed (ReadOnly,
                        0xFED00000,         // Address Base
                        0x00000400,         // Address Length
                        )
                })
            }

            Device (PIC)
            {
                Name (_HID, EisaId ("PNP0000") /* 8259-compatible Programmable Interrupt Controller */)  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0020,             // Range Minimum
                        0x0020,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0024,             // Range Minimum
                        0x0024,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0028,             // Range Minimum
                        0x0028,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x002C,             // Range Minimum
                        0x002C,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0030,             // Range Minimum
                        0x0030,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0034,             // Range Minimum
                        0x0034,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0038,             // Range Minimum
                        0x0038,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x003C,             // Range Minimum
                        0x003C,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00A0,             // Range Minimum
                        0x00A0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00A4,             // Range Minimum
                        0x00A4,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00A8,             // Range Minimum
                        0x00A8,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00AC,             // Range Minimum
                        0x00AC,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00B0,             // Range Minimum
                        0x00B0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00B4,             // Range Minimum
                        0x00B4,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00B8,             // Range Minimum
                        0x00B8,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00BC,             // Range Minimum
                        0x00BC,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x04D0,             // Range Minimum
                        0x04D0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IRQNoFlags ()
                        {2}
                })
            }

            Device (LDRC)
            {
                Name (_HID, EisaId ("PNP0C02") /* PNP Motherboard Resources */)  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Name (RBUF, ResourceTemplate ()
                {
                    IO (Decode16,
                        0x0061,             // Range Minimum
                        0x0061,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0063,             // Range Minimum
                        0x0063,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0065,             // Range Minimum
                        0x0065,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0067,             // Range Minimum
                        0x0067,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0080,             // Range Minimum
                        0x0080,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0092,             // Range Minimum
                        0x0092,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x00B2,             // Range Minimum
                        0x00B2,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (RBUF) /* \_SB_.PCI0.LPCB.LDRC.RBUF */
                }
            }

            Device (RTC)
            {
                Name (_HID, EisaId ("PNP0B00") /* AT Real-Time Clock */)  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0070,             // Range Minimum
                        0x0070,             // Range Maximum
                        0x01,               // Alignment
                        0x08,               // Length
                        )
                })
            }

            Device (TIMR)
            {
                Name (_HID, EisaId ("PNP0100") /* PC-class System Timer */)  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0040,             // Range Minimum
                        0x0040,             // Range Maximum
                        0x01,               // Alignment
                        0x04,               // Length
                        )
                    IO (Decode16,
                        0x0050,             // Range Minimum
                        0x0050,             // Range Maximum
                        0x10,               // Alignment
                        0x04,               // Length
                        )
                    IRQNoFlags ()
                        {0}
                })
            }
        }

        Device (XHCI)
        {
            Name (_ADR, 0x00140000)  // _ADR: Address
            Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
            {
                0x0D, 
                0x03
            })
            Name (_S3D, 0x03)  // _S3D: S3 Device State
            Device (RHUB)
            {
                Name (_ADR, Zero)  // _ADR: Address
                Method (GPLD, 1, Serialized)
                {
                    Name (PCKG, Package (0x01)
                    {
                        Buffer (0x10){}
                    })
                    CreateField (DerefOf (PCKG [Zero]), Zero, 0x07, REV)
                    REV = 0x02
                    CreateField (DerefOf (PCKG [Zero]), 0x40, One, VISI)
                    VISI = Arg0
                    Return (PCKG) /* \_SB_.PCI0.XHCI.RHUB.GPLD.PCKG */
                }

                Device (PRT1)
                {
                    Name (_ADR, One)  // _ADR: Address
                }

                Device (PRT2)
                {
                    Name (_ADR, 0x02)  // _ADR: Address
                }

                Device (PRT3)
                {
                    Name (_ADR, 0x03)  // _ADR: Address
                }

                Device (PRT4)
                {
                    Name (_ADR, 0x04)  // _ADR: Address
                }

                Device (SSP1)
                {
                    Name (_ADR, 0x07)  // _ADR: Address
                }
            }
        }

        Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
        {
            If (PICM)
            {
                Return (Package (0x1C)
                {
                    Package (0x04)
                    {
                        0x0002FFFF, 
                        Zero, 
                        Zero, 
                        0x10
                    }, 

                    Package (0x04)
                    {
                        0x0002FFFF, 
                        One, 
                        Zero, 
                        0x11
                    }, 

                    Package (0x04)
                    {
                        0x0002FFFF, 
                        0x02, 
                        Zero, 
                        0x12
                    }, 

                    Package (0x04)
                    {
                        0x0002FFFF, 
                        0x03, 
                        Zero, 
                        0x13
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        Zero, 
                        Zero, 
                        0x10
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        One, 
                        Zero, 
                        0x11
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        0x02, 
                        Zero, 
                        0x12
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        0x03, 
                        Zero, 
                        0x13
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        Zero, 
                        Zero, 
                        0x10
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        One, 
                        Zero, 
                        0x11
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        0x02, 
                        Zero, 
                        0x12
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        0x03, 
                        Zero, 
                        0x13
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        Zero, 
                        Zero, 
                        0x10
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        One, 
                        Zero, 
                        0x11
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        0x02, 
                        Zero, 
                        0x12
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        0x03, 
                        Zero, 
                        0x13
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        Zero, 
                        Zero, 
                        0x10
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        One, 
                        Zero, 
                        0x11
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        0x02, 
                        Zero, 
                        0x12
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        0x03, 
                        Zero, 
                        0x13
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        Zero, 
                        Zero, 
                        0x10
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        One, 
                        Zero, 
                        0x11
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        0x02, 
                        Zero, 
                        0x12
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        0x03, 
                        Zero, 
                        0x13
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        Zero, 
                        Zero, 
                        0x10
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        One, 
                        Zero, 
                        0x11
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        0x02, 
                        Zero, 
                        0x12
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        0x03, 
                        Zero, 
                        0x13
                    }
                })
            }
            Else
            {
                Return (Package (0x1C)
                {
                    Package (0x04)
                    {
                        0x0002FFFF, 
                        Zero, 
                        ^LPCB.LNKA, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0002FFFF, 
                        One, 
                        ^LPCB.LNKB, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0002FFFF, 
                        0x02, 
                        ^LPCB.LNKC, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0002FFFF, 
                        0x03, 
                        ^LPCB.LNKD, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        Zero, 
                        ^LPCB.LNKA, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        One, 
                        ^LPCB.LNKB, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        0x02, 
                        ^LPCB.LNKC, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0013FFFF, 
                        0x03, 
                        ^LPCB.LNKD, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        Zero, 
                        ^LPCB.LNKA, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        One, 
                        ^LPCB.LNKB, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        0x02, 
                        ^LPCB.LNKC, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0014FFFF, 
                        0x03, 
                        ^LPCB.LNKD, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        Zero, 
                        ^LPCB.LNKA, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        One, 
                        ^LPCB.LNKB, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        0x02, 
                        ^LPCB.LNKC, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001BFFFF, 
                        0x03, 
                        ^LPCB.LNKD, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        Zero, 
                        ^LPCB.LNKA, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        One, 
                        ^LPCB.LNKB, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        0x02, 
                        ^LPCB.LNKC, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001CFFFF, 
                        0x03, 
                        ^LPCB.LNKD, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        Zero, 
                        ^LPCB.LNKA, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        One, 
                        ^LPCB.LNKB, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        0x02, 
                        ^LPCB.LNKC, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001DFFFF, 
                        0x03, 
                        ^LPCB.LNKD, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        Zero, 
                        ^LPCB.LNKA, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        One, 
                        ^LPCB.LNKB, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        0x02, 
                        ^LPCB.LNKC, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x001FFFFF, 
                        0x03, 
                        ^LPCB.LNKD, 
                        Zero
                    }
                })
            }
        }

        Device (RP01)
        {
            Name (_ADR, 0x001C0000)  // _ADR: Address
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (PICM)
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            Zero, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            Zero, 
                            0x11
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            Zero, 
                            0x12
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            Zero, 
                            0x13
                        }
                    })
                }
                Else
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            ^^LPCB.LNKA, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            ^^LPCB.LNKB, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            ^^LPCB.LNKC, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            ^^LPCB.LNKD, 
                            Zero
                        }
                    })
                }
            }
        }

        Device (RP02)
        {
            Name (_ADR, 0x001C0001)  // _ADR: Address
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (PICM)
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            Zero, 
                            0x11
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            Zero, 
                            0x12
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            Zero, 
                            0x13
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            Zero, 
                            0x10
                        }
                    })
                }
                Else
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            ^^LPCB.LNKB, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            ^^LPCB.LNKC, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            ^^LPCB.LNKD, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            ^^LPCB.LNKA, 
                            Zero
                        }
                    })
                }
            }
        }

        Device (RP03)
        {
            Name (_ADR, 0x001C0002)  // _ADR: Address
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (PICM)
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            Zero, 
                            0x12
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            Zero, 
                            0x13
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            Zero, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            Zero, 
                            0x11
                        }
                    })
                }
                Else
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            ^^LPCB.LNKC, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            ^^LPCB.LNKD, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            ^^LPCB.LNKA, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            ^^LPCB.LNKB, 
                            Zero
                        }
                    })
                }
            }
        }

        Device (RP04)
        {
            Name (_ADR, 0x001C0003)  // _ADR: Address
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (PICM)
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            Zero, 
                            0x13
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            Zero, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            Zero, 
                            0x11
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            Zero, 
                            0x12
                        }
                    })
                }
                Else
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0xFFFF, 
                            Zero, 
                            ^^LPCB.LNKD, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            One, 
                            ^^LPCB.LNKA, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x02, 
                            ^^LPCB.LNKB, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0xFFFF, 
                            0x03, 
                            ^^LPCB.LNKC, 
                            Zero
                        }
                    })
                }
            }
        }

        Scope (\_SB)
        {
            Device (GPSC)
            {
                Name (_HID, "INT33FC" /* Intel Baytrail GPIO Controller */)  // _HID: Hardware ID
                Name (_CID, "INT33FC" /* Intel Baytrail GPIO Controller */)  // _CID: Compatible ID
                Name (_UID, One)  // _UID: Unique ID
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y04)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                    {
                        0x00000031,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.GPSC._Y04._BAS, RBAS)  // _BAS: Base Address
                    RBAS = 0xFED0C000
                    Return (RBUF) /* \_SB_.GPSC.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }
            }

            Device (GPNC)
            {
                Name (_HID, "INT33FC" /* Intel Baytrail GPIO Controller */)  // _HID: Hardware ID
                Name (_CID, "INT33FC" /* Intel Baytrail GPIO Controller */)  // _CID: Compatible ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y05)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                    {
                        0x00000030,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.GPNC._Y05._BAS, RBAS)  // _BAS: Base Address
                    RBAS = 0xFED0D000
                    Return (RBUF) /* \_SB_.GPNC.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }
            }

            Device (GPSS)
            {
                Name (_HID, "INT33FC" /* Intel Baytrail GPIO Controller */)  // _HID: Hardware ID
                Name (_CID, "INT33FC" /* Intel Baytrail GPIO Controller */)  // _CID: Compatible ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y06)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                    {
                        0x00000032,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.GPSS._Y06._BAS, RBAS)  // _BAS: Base Address
                    RBAS = 0xFED0E000
                    Return (RBUF) /* \_SB_.GPSS.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }
            }
        }

        Scope (\_SB.PCI0)
        {
            Device (SDM1)
            {
                Name (_HID, "INTL9C60" /* Intel Baytrail SOC DMA Controller */)  // _HID: Hardware ID
                Name (_UID, One)  // _UID: Unique ID
                Name (_DDN, "DMA Controller #1")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y07)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000002A,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.SDM1._Y07._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S0B0 /* \S0B0 */
                    Return (RBUF) /* \_SB_.PCI0.SDM1.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S0EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }
            }

            Device (SDM2)
            {
                Name (_HID, "INTL9C60" /* Intel Baytrail SOC DMA Controller */)  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Name (_DDN, "DMA Controller #2")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y08)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000002B,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.SDM2._Y08._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S8B0 /* \S8B0 */
                    Return (RBUF) /* \_SB_.PCI0.SDM2.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S8EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }
            }

            Device (I2C1)
            {
                Name (_HID, "80860F41" /* Intel Baytrail I2C Host Controller */)  // _HID: Hardware ID
                Name (_UID, One)  // _UID: Unique ID
                Name (_DDN, "I2C Controller #1")  // _DDN: DOS Device Name
                Name (SSCN, Package (0x03)
                {
                    0x0200, 
                    0x0200, 
                    0x06
                })
                Name (FMCN, Package (0x03)
                {
                    0x55, 
                    0x99, 
                    0x06
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y09)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000020,
                    }
                    FixedDMA (0x0010, 0x0000, Width32bit, )
                    FixedDMA (0x0011, 0x0001, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.I2C1._Y09._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S1B0 /* \S1B0 */
                    Return (RBUF) /* \_SB_.PCI0.I2C1.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S1EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S1B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (I2C2)
            {
                Name (_HID, "80860F41" /* Intel Baytrail I2C Host Controller */)  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Name (_DDN, "I2C Controller #2")  // _DDN: DOS Device Name
                Name (SSCN, Package (0x03)
                {
                    0x0200, 
                    0x0200, 
                    0x06
                })
                Name (FMCN, Package (0x03)
                {
                    0x55, 
                    0x99, 
                    0x06
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y0A)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000021,
                    }
                    FixedDMA (0x0012, 0x0002, Width32bit, )
                    FixedDMA (0x0013, 0x0003, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.I2C2._Y0A._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S2B0 /* \S2B0 */
                    Return (RBUF) /* \_SB_.PCI0.I2C2.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S2EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S2B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (I2C3)
            {
                Name (_HID, "80860F41" /* Intel Baytrail I2C Host Controller */)  // _HID: Hardware ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Name (_DDN, "I2C Controller #3")  // _DDN: DOS Device Name
                Name (SSCN, Package (0x03)
                {
                    0x0200, 
                    0x0200, 
                    0x06
                })
                Name (FMCN, Package (0x03)
                {
                    0x55, 
                    0x99, 
                    0x06
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y0B)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000022,
                    }
                    FixedDMA (0x0014, 0x0004, Width32bit, )
                    FixedDMA (0x0015, 0x0005, Width32bit, )
                })
                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.I2C3._Y0B._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S3B0 /* \S3B0 */
                    Return (RBUF) /* \_SB_.PCI0.I2C3.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S3EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S3B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (I2C4)
            {
                Name (_HID, "80860F41" /* Intel Baytrail I2C Host Controller */)  // _HID: Hardware ID
                Name (_UID, 0x04)  // _UID: Unique ID
                Name (_DDN, "I2C Controller #4")  // _DDN: DOS Device Name
                Name (SSCN, Package (0x03)
                {
                    0x0200, 
                    0x0200, 
                    0x06
                })
                Name (FMCN, Package (0x03)
                {
                    0x55, 
                    0x99, 
                    0x06
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y0C)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000023,
                    }
                    FixedDMA (0x0016, 0x0006, Width32bit, )
                    FixedDMA (0x0017, 0x0007, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.I2C4._Y0C._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S4B0 /* \S4B0 */
                    Return (RBUF) /* \_SB_.PCI0.I2C4.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S4EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S4B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (I2C5)
            {
                Name (_HID, "80860F41" /* Intel Baytrail I2C Host Controller */)  // _HID: Hardware ID
                Name (_UID, 0x05)  // _UID: Unique ID
                Name (_DDN, "I2C Controller #5")  // _DDN: DOS Device Name
                Name (SSCN, Package (0x03)
                {
                    0x0200, 
                    0x0200, 
                    0x06
                })
                Name (FMCN, Package (0x03)
                {
                    0x55, 
                    0x99, 
                    0x06
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y0D)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000024,
                    }
                    FixedDMA (0x0018, 0x0000, Width32bit, )
                    FixedDMA (0x0019, 0x0001, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.I2C5._Y0D._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S5B0 /* \S5B0 */
                    Return (RBUF) /* \_SB_.PCI0.I2C5.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S5EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S5B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (I2C6)
            {
                Name (_HID, "80860F41" /* Intel Baytrail I2C Host Controller */)  // _HID: Hardware ID
                Name (_UID, 0x06)  // _UID: Unique ID
                Name (_DDN, "I2C Controller #6")  // _DDN: DOS Device Name
                Name (SSCN, Package (0x03)
                {
                    0x0200, 
                    0x0200, 
                    0x06
                })
                Name (FMCN, Package (0x03)
                {
                    0x55, 
                    0x99, 
                    0x06
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y0E)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000025,
                    }
                    FixedDMA (0x001A, 0x0002, Width32bit, )
                    FixedDMA (0x001B, 0x0003, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.I2C6._Y0E._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S6B0 /* \S6B0 */
                    Return (RBUF) /* \_SB_.PCI0.I2C6.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S6EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S6B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (I2C7)
            {
                Name (_HID, "80860F41" /* Intel Baytrail I2C Host Controller */)  // _HID: Hardware ID
                Name (_UID, 0x07)  // _UID: Unique ID
                Name (_DDN, "I2C Controller #7")  // _DDN: DOS Device Name
                Name (SSCN, Package (0x03)
                {
                    0x0200, 
                    0x0200, 
                    0x06
                })
                Name (FMCN, Package (0x03)
                {
                    0x55, 
                    0x99, 
                    0x06
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y0F)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000026,
                    }
                    FixedDMA (0x001C, 0x0004, Width32bit, )
                    FixedDMA (0x001D, 0x0005, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.I2C7._Y0F._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S7B0 /* \S7B0 */
                    Return (RBUF) /* \_SB_.PCI0.I2C7.RBUF */
                }

                Method (_HRV, 0, NotSerialized)  // _HRV: Hardware Revision
                {
                    Return (0x06)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S7EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S7B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (SPI1)
            {
                Name (_HID, "80860F0E" /* Intel SPI Controller */)  // _HID: Hardware ID
                Name (_UID, One)  // _UID: Unique ID
                Name (_DDN, "SPI Controller #2")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y10)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000029,
                    }
                    FixedDMA (0x0000, 0x0000, Width32bit, )
                    FixedDMA (0x0001, 0x0001, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.SPI1._Y10._BAS, RBAS)  // _BAS: Base Address
                    RBAS = S9B0 /* \S9B0 */
                    Return (RBUF) /* \_SB_.PCI0.SPI1.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((S9EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, S9B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (PWM1)
            {
                Name (_HID, "80860F09" /* Intel PWM Controller */)  // _HID: Hardware ID
                Name (_UID, One)  // _UID: Unique ID
                Name (_DDN, "PWM Controller #1")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y11)
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.PWM1._Y11._BAS, RBAS)  // _BAS: Base Address
                    RBAS = SAB0 /* \SAB0 */
                    Return (RBUF) /* \_SB_.PCI0.PWM1.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((SAEN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }
            }

            Device (PWM2)
            {
                Name (_HID, "80860F09" /* Intel PWM Controller */)  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Name (_DDN, "PWM Controller #2")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y12)
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.PWM2._Y12._BAS, RBAS)  // _BAS: Base Address
                    RBAS = SBB0 /* \SBB0 */
                    Return (RBUF) /* \_SB_.PCI0.PWM2.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((SBEN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }
            }

            Device (UAR1)
            {
                Name (_HID, "80860F0A" /* Intel Atom UART Controller */)  // _HID: Hardware ID
                Name (_UID, One)  // _UID: Unique ID
                Name (_DDN, "HS-UART Controller #1")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y13)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000027,
                    }
                    FixedDMA (0x0002, 0x0002, Width32bit, )
                    FixedDMA (0x0003, 0x0003, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.UAR1._Y13._BAS, RBAS)  // _BAS: Base Address
                    RBAS = SCB0 /* \SCB0 */
                    Return (RBUF) /* \_SB_.PCI0.UAR1.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((SCEN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, SCB1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (UAR2)
            {
                Name (_HID, "80860F0A" /* Intel Atom UART Controller */)  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Name (_DDN, "HS-UART Controller #2")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y14)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000028,
                    }
                    FixedDMA (0x0004, 0x0004, Width32bit, )
                    FixedDMA (0x0005, 0x0005, Width32bit, )
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.UAR2._Y14._BAS, RBAS)  // _BAS: Base Address
                    RBAS = SDB0 /* \SDB0 */
                    Return (RBUF) /* \_SB_.PCI0.UAR2.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((SDEN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, SDB1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (EMMC)
            {
                Name (_HID, "80860F14" /* Intel Baytrail SDIO/MMC Host Controller */)  // _HID: Hardware ID
                Name (_CID, "PNP0D40" /* SDA Standard Compliant SD Host Controller */)  // _CID: Compatible ID
                Name (_UID, One)  // _UID: Unique ID
                Name (_DDN, "eMMC Controller 4.5")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y15)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000002C,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.EMMC._Y15._BAS, RBAS)  // _BAS: Base Address
                    RBAS = C0B0 /* \C0B0 */
                    Return (RBUF) /* \_SB_.PCI0.EMMC.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((C0EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, C0B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }

                Device (EM45)
                {
                    Name (_ADR, 0x08)  // _ADR: Address
                    Method (_RMV, 0, NotSerialized)  // _RMV: Removal Status
                    {
                        Return (Zero)
                    }
                }
            }

            Device (SDIO)
            {
                Name (_HID, "INT33BB" /* Intel Baytrail SD Host Controller */)  // _HID: Hardware ID
                Name (_CID, "PNP0D40" /* SDA Standard Compliant SD Host Controller */)  // _CID: Compatible ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Name (_DDN, "SDIO Controller")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y16)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000002E,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.SDIO._Y16._BAS, RBAS)  // _BAS: Base Address
                    RBAS = C1B0 /* \C1B0 */
                    Return (RBUF) /* \_SB_.PCI0.SDIO.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((C1EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, C1B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (SDCD)
            {
                Name (_HID, "80860F16")  // _HID: Hardware ID
                Name (_CID, "PNP0D40" /* SDA Standard Compliant SD Host Controller */)  // _CID: Compatible ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Name (_DDN, "SD Card Controller")  // _DDN: DOS Device Name
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y17)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000002F,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.SDCD._Y17._BAS, RBAS)  // _BAS: Base Address
                    RBAS = C2B0 /* \C2B0 */
                    Return (RBUF) /* \_SB_.PCI0.SDCD.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((C2EN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, C2B1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    PSAT |= 0x03
                    PSAT |= Zero
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    PSAT &= 0xFFFFFFFC
                    PSAT |= Zero
                }
            }

            Device (LPEA)
            {
                Name (_HID, "80860F28" /* Intel SST Audio DSP */)  // _HID: Hardware ID
                Name (_CID, "80860F28" /* Intel SST Audio DSP */)  // _CID: Compatible ID
                Name (_UID, One)  // _UID: Unique ID
                Name (_DDN, "Low Power Audio Controller")  // _DDN: DOS Device Name
                Name (_PR0, Package (0x01)  // _PR0: Power Resources for D0
                {
                    PLPE
                })
                Name (RBUF, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00200000,         // Address Length
                        _Y18)
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00001000,         // Address Length
                        _Y19)
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00100000,         // Address Length
                        _Y1A)
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000018,
                    }
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x00000019,
                    }
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000001A,
                    }
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000001B,
                    }
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000001C,
                    }
                    Interrupt (ResourceConsumer, Level, ActiveLow, Exclusive, ,, )
                    {
                        0x0000001D,
                    }
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (RBUF, \_SB.PCI0.LPEA._Y18._BAS, BAS0)  // _BAS: Base Address
                    BAS0 = LPB0 /* \LPB0 */
                    CreateDWordField (RBUF, \_SB.PCI0.LPEA._Y19._BAS, BAS1)  // _BAS: Base Address
                    BAS1 = LPB1 /* \LPB1 */
                    CreateDWordField (RBUF, \_SB.PCI0.LPEA._Y1A._BAS, BAS2)  // _BAS: Base Address
                    BAS2 = LPFW /* \LPFW */
                    If (CondRefOf (^GBUF))
                    {
                        ConcatenateResTemplate (RBUF, GBUF, Local1)
                        Return (Local1)
                    }

                    Return (RBUF) /* \_SB_.PCI0.LPEA.RBUF */
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If ((LPEN == One))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                OperationRegion (KEYS, SystemMemory, LPB1, 0x0100)
                Field (KEYS, DWordAcc, NoLock, WriteAsZeros)
                {
                    Offset (0x84), 
                    PSAT,   32
                }

                PowerResource (PLPE, 0x00, 0x0000)
                {
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Return (One)
                    }

                    Method (_OFF, 0, NotSerialized)  // _OFF: Power Off
                    {
                        PSAT |= 0x03
                        PSAT |= Zero
                    }

                    Method (_ON, 0, NotSerialized)  // _ON_: Power On
                    {
                        PSAT &= 0xFFFFFFFC
                        PSAT |= Zero
                    }
                }
            }
        }

        Device (GFX0)
        {
            Name (_ADR, 0x00020000)  // _ADR: Address
        }
    }

    Name (SSFG, 0x0D)
    If (Zero)
    {
        SSFG &= 0xFE
    }

    If (Zero)
    {
        SSFG &= 0xF7
    }

    If (CondRefOf (\OSFG))
    {
        SSFG = OSFG /* External reference */
    }

    Name (_S0, Package (0x04)  // _S0_: S0 System State
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If ((SSFG & One))
    {
        Name (_S1, Package (0x04)  // _S1_: S1 System State
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If ((SSFG & 0x04))
    {
        Name (_S3, Package (0x04)  // _S3_: S3 System State
        {
            0x05, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If ((SSFG & 0x08))
    {
        Name (_S4, Package (0x04)  // _S4_: S4 System State
        {
            0x06, 
            0x04, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)  // _S5_: S5 System State
    {
        0x07, 
        Zero, 
        Zero, 
        Zero
    })
    Scope (_SB.PCI0.LPEA)
    {
        Name (GBUF, Buffer (0x02)
        {
             0x79, 0x00                                       // y.
        })
    }
}

